﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EntityCommands;
using BMS.VistaIntegration.Via.Commands.EVS;
using Mdws2ORM;
using Mdws2ORM.Core;
using Mdws2ORM.Maps;

namespace BMS.VistaIntegration.Via.Commands.EIS
{
    public class ListWardLocationCommand : BaseListCommand<WardLocation>
    {
        public const string Target = "ListWardLocation";
        public const int ArgumentsCount = 3;

        public ListWardLocationCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        protected override string GetTarget()
        {
            return Target;
        }

        protected override IEnumerable<object> GetCriteria()
        {
            return new object[] { string.Empty }.Concat(base.GetCriteria());
        }

        protected override IDependencySource GetDependencySource()
        {
            return WardLocationDependencySource.Instance;
        }
    }

    internal sealed class WardLocationDependencySource : IDependencySource
    {
        private static IDependencySource instance;

        private WardLocationDependencySource()
        {
        }

        public static IDependencySource Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new WardLocationDependencySource();
                }

                return instance;
            }
        }

        public IEnumerable<DependentEntityInfo> GetDependentTypes()
        {
            yield return new DependentEntityInfo<Specialty>(ListSpecialtyCommand.Target, ListSpecialtyCommand.ArgumentsCount, ".017");
        }
    }
}
